package gov.va.vamf.scheduling.direct.datalayer.facility;

import gov.va.vamf.scheduling.direct.domain.CustomMessage;
import gov.va.vamf.scheduling.direct.domain.CustomMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;

@Service
public class CustomMessageService {

    @Autowired
    private CustomMessageRepository customMessageRepository;

    public CustomMessages fetchCustomMessagesBySiteCode(String siteCode) {
        CustomMessages customMessages = customMessageRepository.findBySiteCode(siteCode);
        return customMessages;
    }

    public CustomMessages fetchCustomMessagesBySiteCodeAndMessageIds(final String siteCode, final Collection<String> messageIds) {
        final CustomMessages customMessages;

        if (messageIds == null || messageIds.isEmpty()) {
            // Passing a null or empty collection to findBySiteCodeAndMessageIdIn will always yield no results, so
            // query by site code only.
            customMessages = fetchCustomMessagesBySiteCode(siteCode);
        }
        else {
            customMessages = customMessageRepository.findBySiteCodeAndMessageIdIn(siteCode, messageIds);
        }

        return customMessages;
    }

    public CustomMessage saveCustomMessage(CustomMessage customMessage) {

        customMessage.setLastModifiedDate(new Date());

        return customMessageRepository.save(customMessage);
    }
}
